%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% MODEL: CALIBRATION AND SOLUTION
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
%% Parameter values
%% 1. Aggregate demand equation
% lgdp_gap = a1*lgdp_gap{+1} + a2*lgdp_gap{-1} - a3*mci + a4*lx_gdp_gap + a6*lqforcmd_gap + e_lgdp_gap;
 
% mci = a5*(lrr_gap) + (1-a5)*(- lz_gap);
 
% a1 - forward-looking expectations of aggregate demand 
p.a1 = 0.15;
 
% a2 - aggregate demand persistence
p.a2 = 0.6; %0.7654; %0.7294; %0.75; %0.65; %0.7
 
% a3 - policy passthrough (impact of monetary policy on real economy)
p.a3 = 0.15; %0.2; %0.15; %0.25; %0.4
 
% a4 - external demand impact
p.a4 = 0.15; %0.2085; %0.12; %0.2122; %0.12; %0.2;
 
% a5 - weight of real interest rate and real exchange rate in monetary
% conditions
p.a5 = 0.95; %0.9; %0.7; %0.8;
 
% a6 - mining sector passthrough
p.a6 = 0.01; %0.066; %0.05; %0.1;
 
%% 2. Aggregat supply bloc
% 2.1 Services inflation
% dot_cpi_serv =  b11*(dot4_cpi{+1} + dot_rp_serv_eq) + (1-b11-b12-b16)*dot_cpi_serv{-1} + b12*dot_pm_serv + ...
%                 b13*rmc_serv + b16*(dot_w + dot_emp_eq - dot_gdp_eq + dot_rp_serv_eq) + e_dot_cpi_serv; 
            
% rmc_serv = b14*(lgdp_gap + (lrw_gap - lrp_serv_gap)) + (1-b14)*(lz_gap - lrp_serv_gap);
 
% b11 - forward-looking inflation expectations
p.b11 = 0.2; %0.2; %0.3; %0.5 Calibrated using OLS
 
% b12 - direct passthrough from import prices
p.b12 = 0.0; %0.0479; %0.0263; %0.02; %0.05
 
% b13 - rmc passthrough (impact of rmc on inflation)
p.b13 = 0.2; %0.125; %0.5; %0.3
 
% b14 - ratio of domestic intermediate goods in firms marginal costs 
p.b14 = 0.85; %0.9; %0.9659; %0.888; %0.3;

p.b15 = 0.6052;
 
% b16 - passthrough from nominal ULC to inflation
p.b16 = 0; %0.143; 0.4;
 
%% 2. Aggregat supply bloc
% 2.2 Core goods inflation
% dot_cpi_goodsx =  b21*(dot4_cpi{+1} + dot_rp_goodsx_eq) + (1-b21-b22-b26)*dot_cpi_goodsx{-1} + b22*dot_pm_goodsx + ...
%                  b23*rmc_goodsx + b26*(dot_w + dot_emp_eq - dot_gdp_eq + dot_rp_goodsx_eq) + e_dot_cpi_goodsx; 
 
% rmc_goodsx = b24*(lgdp_gap + (lrw_gap - lrp_goodsx_gap)) + (1-b24)*(lz_gap - lrp_goodsx_gap);
 
% b21 - forward-looking inflation expectations
p.b21 = 0.25; %0.3; %0.5 Calibrated using OLS
 
% b22 - direct passthrough from import prices
p.b22 = 0.04; %0.02; %0.05
 
% b23 - rmc passthrough (impact of rmc on inflation)
p.b23 = 0.25; %0.290; %0.5; %0.3
 
% b24 - ratio of domestic intermediate goods in firms marginal costs 
p.b24 = 0.9; %0.793; %0.3;

p.b25 = 0.4254; %0.5;

% b26 - passthrough from nominal ULC to inflation
p.b26 = 0.0; %0.219; %0.4;
 
%% 2. Aggregat supply bloc
% 2.3 Import prices (core inflation)
% dot_pm_serv = d1*dot_pm_serv{-1} + (1-d1)*(dot_s + dot_x_cpi - dot_z_eq + dot_rp_serv_eq) + e_dot_pm_serv;
% dot_pm_goodsx = d1*dot_pm_goodsx{-1} + (1-d1)*(dot_s + dot_x_cpi - dot_z_eq + dot_rp_goodsx_eq) + e_dot_pm_goodsx;
 
% d1 - persistence in import prices
p.d1 = 0.1;
 
%% 2.4 Food inflation
% dot_cpi_food = b31*dot_cpi_food{-1} + (1-b31-b32-b36)*(dot4_cpi{+1} + dot_rp_food_eq)...
%     + b32*(dot_food + dot_s) + b33*rmc_food + b36*dot4_cpi_petr + e_dot_cpi_food;
 
% rmc_food = b34*(b35*lgdp_gap + (1-b35)*(lrw_gap - lrp_food_gap)) + (1-b34)*(lqfood_gap + lz_gap - lrp_food_gap); 
 
% b31 - persistence in domestic food price
p.b31 = 0.6499; %0.723; %0.6; %0.424; %0.4
 
% b32 - direct passthrough from world food prices
p.b32 = 0.0123; %0.025; %0.05;
 
% b33 - rmc passthrough (food prices)
p.b33 = 0.3296/2; %0.295; %0.15;
 
% b34 - ratio of domestic pressure in "rmc"
p.b34 = 0.8;
 
% b35 - ratio of output gap and real wage gap in the domestic part of "rmc"
p.b35 = 0.5;
 
% b36 - spillover of petrol into food prices
p.b36 = 0.033; %0.06;
 
%% 2.4 Electicity prices
% dot_cpi_elec = b41*dot_cpi_elec{-1} + (1-b41)*(dot_cpi{+1} ...
%     + dot_rp_elec_eq) + b42*rmc_elec + e_dot_cpi_elec;
 
% rmc_elec = (b43*lgdp_gap + (1-b43)*(lrw_gap - lrp_elec_gap));
 
% b41 - persistence in electricity prices
p.b41 = 0.65; %0.2; %0.5;
 
% b42 - rmc passthrough (electricity prices)
p.b42 = 0.1; %0.3; 
 
% b43 - share of wages relative to output gap
p.b43 = 0.1; 
 
%% 2.5 Petrol inflation
% dot_cpi_petr = b51*dot_cpi_petr{-1} + (1-b51-b52)*(dot4_cpi{+1} +  ...
%     dot_rp_petr_eq) + b52*(dot_oil + dot_s) + b53*rmc_petr + e_dot_cpi_petr;
 
% rmc_petr =  (lqoil_gap + lz_gap - lrp_petr_gap)
 
% b51 - persistence in petrol prices
p.b51 = 0.2;
 
% b52 - ratio of oil*ZARUSD in domestic total petrol price (i.e. take account of taxes)
p.b52 = 0.3488; %0.43; %0.5 %0.28
 
% b53 - rmc passthrough (petrol prices)
p.b53 = 0.0928; %0.15;
 
%% 2.6 Wage inflation
% dot_w = (1-w1-w3)*dot_w{+1} + w1*dot_w{-1} - w2*(lrw_gap - lgdp_gap) + w3*(dot_cpi{-4}+dot_rw_eq) + e_dot_w;
 
% w1 - backward-looking wage expectations
p.w1 = 0.2; %0.0; %0.37; %0.4;
 
% w2 - passthrough from labor market
p.w2 = 0.0817; %0.1; %0.14; %0.2;
 
% w3 - backward wage indexation to CPI
 
p.w3 = 0.5512; %0.61; %0.61; %0.20; %0.25;
 
%% 2.7 Employment
% lemp_gap = k1*lemp_gap{-1} + k2*lgdp_gap + e_lemp_gap;
 
% k1 employment persistence
p.k1 = 0; %0.4; %0.7; %0.8;
 
% k2 "Okun's Law"
p.k2 = 0.5;
 
%% 3. Uncovered Interest Rate Parity (UIP with partly backward-looking element)
% ls = e1*ls{+1} + (1-e1)*(ls{-1} + 2/4*(target - ss_dot_x_cpi + dot_z_eq)) + (- rn + x_rn + prem)/4 + e_ls; 
 
% lz = lz{+1} - e2*(lz{+1} - lz{-1} + lcpi{+1} - lcpi{-1} - lx_cpi{+1} + lx_cpi{-1}) ...
%         + e2*2/4*(target - ss_dot_x_cpi + dot_z_eq) ...
%         + (- (lrr) + (x_rn - dot_x_cpi{+1}) + prem)/4 + e_ls;
 
% e1 - forward-looking exchange rate expectations 
p.e1 = 0.9; % 0.9;
 
p.e2 = 0.6; %1-p.e1;
 
%% 4. Monetary policy rule
% rn = f1*rn{-1} + (1-f1)*(rn_neutral + f2*(dot_cpi{+1} - target) + f3*lgdp_gap) + e_rn;
 
% f1 - policy persistence
p.f1 = 0.7906; %0.78; %0.8;
 
% f2 - policy reactiveness (weight put on inflation by policy maker)
 
p.f2 = 1.57; %1.9399; %1.679; %1.5;
 
% f3 - policy reactiveness (weight put on output gap by policy maker)
p.f3 = 0.54; %0.6950; %0.627;

% f4 - AR on policy shock

p.f4 = 0.0;
 
%% 5. Mining sector
% g1 - temporary impact of deviation of the real foreign commodities price from its trend on risk
% premium
p.g1 = 0; %0.05; %0.2;
 
% g2 - impact of change in the trend real foreign commodities price on trend change in the
% real exchange rate
p.g2 = 0; %0.18; %0.5; %0.025; %0.1;
 
% g3 - persistence in convergence of trend real foreign commodities price to its
% steady-state level
p.g3 = 0.7; %0.7
 
% g4 - persistence in deviation of the real foreign commodities price from its trend
p.g4 = 0.5;
 
%% 5. Speed of convergence of selected variables to their trend values.
% Used for risk premium, trends, foreign variables and world commodity prices, 
 
% persistent shock to risk premium
% shock_prem = h0*shock_prem{-1} + e_prem;
p.h0 = 0.8;
 
% persistence in onvergence of trend variables to their steady-state levels
% applies for dot_gdp_eq, dot_z_eq, rr_eq, x_rr_eq and dot_emp_eq
% example:
% dot_z_eq = h1*dot_z_eq{-1} + (1-h1)*ss_dot_z_eq + e_dot_z_eq and
% dot_gdp_eq = h1*dot_gdp_eq{-1} + (1-h1)*ss_dot_gdp_eq + e_dot_gdp_eq;
p.h1 = 0.5;
 
% persistence in foreign GDP 
% lx_gdp_gap = h2*lx_gdp_gap{-1} + e_lx_gdp_gap;
p.h2 = 0.5;
 
% persistence in foreign interest rates and inflation;
% example:
%x_rn = h5*x_rn{-1} + (1-h3)*(x_rr_eq + dot_x_cpi) + e_x_rn;
p.h3 = 0.5;
 
% real eq persistence
% rr_eq = h4*rr_eq{-1} + (1-h4)*ss_rr_eq + e_rr_eq;
p.h4 = 0.8; %0.2; %0.5
 
p.h5 = 0.05;
p.h6 = 0.1; % estimated from a basic OLS of prem on term20 
p.h7 = 0.3; % estimated from a basic OLS of prem on term40 (check polynomial function)
 
%% Persistence of underlying potential growth
 
p.j1 = 0.98; 
 
p.jx1 = 0.98; % 0.9 
% % Effect of world potential growth on SA potential growth
% p.h5

p.theta = 0.158;
  
% Speed of inflation target adjustment to the medium-term target (higher
% values mean slower adjustment)
% target = t1*target{-1} + (1-t1)*target_ss + e_target;
p.t1 =  0.7; %0.5;
 
%% The inflation target and observed economic trends
 
% Domestic inflation target
p.target_ss = 4.5; %5
 
% Domestic core goods steady states
p.dot_rp_goodsx_eq_ss = -1.0;
p.ss_dot_cpi_goodsx = p.target_ss + p.dot_rp_goodsx_eq_ss;
 
% Domestic electricity steady states
p.dot_rp_elec_eq_ss = 3.5;
p.ss_dot_cpi_elec = p.target_ss + p.dot_rp_elec_eq_ss;

p.dot_rp_petr_eq_ss = 1;
p.ss_dot_pettax = p.target_ss + p.dot_rp_petr_eq_ss;
 
% Foreign trend inflation
p.ss_dot_x_cpi = 2; %2
% Calibrated trend level of domestic real interest rate 
p.ss_rr_eq = 2.5; %2
% Calibrated trend change in the real exchange rate (negative number is 
% real appreciation);
p.ss_dot_z_eq = 0; %0.5;
% Calibrated trend growth of potential output 
p.ss_g = 2.5; %2.5
% Calibrated trend growth of employment
p.ss_dot_emp_eq = 0.4;
% Calibrated trend level of foreign real interest rate
p.ss_x_rr_eq = 0.5; %1
% Calibrated change in the global relative price of food
p.ss_dot_qfood_eq = 1.0; %1.5; %2
% Calibrated change in the real price of foreign commodities
p.ss_dot_qforcmd_eq = 0; %0
% Calibrated change in the global relative price of oil
p.ss_dot_qoil_eq = 1.0; %1.5
 
% p.ss_rr10_eq = p.ss_rr_eq + 2;
 
p.ss_prem_eq = p.ss_rr_eq - p.ss_x_rr_eq- p.ss_dot_z_eq;
p.ss_g_x = 3.72;
p.ss_term8 = 0.3;
p.ss_term20 = 0.75;
p.ss_term40 = 1.5;
 
p.fact_g = 0.3; % spill-over of global potential growth, roughly based on X/GDP share
p.fact_level = 0.3; % spill-over of global potential growth, roughly based on X/GDP share
 
p.lrrw01 = 0.4; %0.1
% p.lrrw04 = 0.30; %0.35;
p.lrrw08 = 0.30; %0.35;
p.lrrw20 = 0.20;
p.lrrw40 = 0.10;

%% Toggles between CPI and CPI excl. VAT shock in the MP rule
p.vat_switch = 1;
 
%% Model solving--a brief description of commands
% Command 'model' reads the text file 'model.mod' (contains the model's
% equations), assigns the parameters and trend values preset in the database
% 'p' (see readmodel) and transforms the model for the matrix algebra. 
% Transformed model is written in the object 'm'. 
% p.a3 = 0.2; 
 
m = model('model.model','linear=',false,'assign=',p,'method=','selective');
 
% Command 'solve' takes the model saved in object 'm' and solves the model
% for its reduced form (Blanchard-Kahn algorithm). The reduced form is  
% written back in the object 'm'   
m = sstate(m,'maxfunevals=',50000,'growth=',true,'blocks=',true);
% chksstate(m);
m = solve(m);
 
% Command 'sstate' takes the solved model in object 'm', calculates the model's
% steady-state and writes everything back in the object 'm'. Typing 'mss' in
% Matlab command window provides the steady-state values.
% m = sstate(m);
 
mss = get(m,'sstate');
 
% Save model to mat file
save('model.mat','m');
% save('../infrastructure/model/model.mat','m');


